<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_Setup_Model extends CI_Model {

	var $table = 'mainmenu';
	var $column_order = array('menu',null); //set column field database for datatable orderable
	var $column_search = array('menu'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order = array('menuidno' => ''); // default order

	var $table1 = 'mainmenu';
	var $column_order1 = array('menu',null); //set column field database for datatable orderable
	var $column_search1 = array('menu'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order1 = array('menuidno' => 'asc'); // default order

	var $table2 = 'userlvl';

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _msm_get_datatables_query()
	{
		$this->db->where('menutype','Main');
		$this->db->from($this->table);

		$i = 0;

		foreach ($this->column_search as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function msm_get_datatables()
	{
		$this->_msm_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function msm_count_filtered()
	{
		$this->_msm_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function msm_count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	public function msm_get_by_id($menuidno)
	{$this->db->select('*');
		$this->db->from($this->table);
		$this->db->where('menuidno',$menuidno);
		$query = $this->db->get();
		return $query->row();
	}

	public function msm_save($data)
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}
	public function msm_update($where, $data)
	{
		$this->db->update($this->table, $data, $where);
		return $this->db->affected_rows();
	}

	public function msm_delete_by_id($menuidno)
	{
		$this->db->where('menuidno', $menuidno);
		$this->db->delete($this->table);


	}
	private function _smsm_get_datatables_query()
	{
		if(isset($_SESSION['TRY']))
		{
		$this->db->where('menuof',$_SESSION['TRY']);
		}
		$this->db->from($this->table1);

		$i = 0;

		foreach ($this->column_search1 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search1) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order1[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order1))
		{
			$order1 = $this->order1;
			$this->db->order_by(key($order1), $order1[key($order1)]);
		}
	}

	function smsm_get_datatables()
	{
		$this->_smsm_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function smsm_count_filtered()
	{
		$this->_smsm_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function smsm_count_all()
	{
		$this->db->from($this->table1);
		return $this->db->count_all_results();
	}

	public function smsm_get_by_id($menuidno)
	{$this->db->select('*');
		$this->db->from($this->table1);
		$this->db->where('menuidno',$menuidno);
		$query = $this->db->get();
		return $query->row();
	}

	public function smsm_save($data)
	{
		$this->db->insert($this->table1, $data);
		return $this->db->insert_id();
	}
	public function smsm_update($where, $data)
	{
		$this->db->update($this->table1, $data, $where);
		return $this->db->affected_rows();
	}

	public function smsm_delete_by_id($menuidno)
	{
		$this->db->where('menuidno', $menuidno);
		$this->db->delete($this->table1);

	}

	public function userlvl_get_datatables()
	{
		$this->load->database();
		$query=$this->db->get('userlvl');
		return $query->result();
	}

		function count_rec_mainmenu(){
		$this->load->database();
		$this->db->where('menutype', 'Main');
		$query=$this->db->get('mainmenu');
		return $query->num_rows();
	}

		 function msm_save_emplmenu($data1)
	{
		$this->db->insert('emplmenu', $data1);
		return $this->db->insert_id();
	}

		public function mainmenu_get_datatables($data2)
	{
		$this->load->database();
		$this->db->where('menuidno', $data2);
		$query=$this->db->get('mainmenu');
		return $query->result();
	}

	public function menusegment_get_datatables($data3)
	{
		$this->load->database();
		$this->db->where('menu', $data3);
		$this->db->where('menutype', 'Main-Menu');
		$query=$this->db->get('emplmenu');
		return $query->result();
	}

			function count_rec_submenu($data4){
		$this->load->database();
		$this->db->where('menuof', $data4);
		$query=$this->db->get('mainmenu');
		return $query->num_rows();
	}

}
