<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee_model extends CI_Model {

	var $table = 'employee';
	var $column_order = array('firstname','lastname','middlename','emplidno','birthdate',null); //set column field database for datatable orderable
	var $column_search = array('firstname','lastname','emplidno'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order = array('emplidno' => 'desc'); // default order

	var $table1 = 'empleduc';
	var $column_order1 = array('yeargrad','minor','major','emplidno','honors',null); //set column field database for datatable orderable
	var $column_search1 = array('yeargrad','honors','emplidno'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order1 = array('emplidno' => 'desc'); // default order

	var $table5 = 'emplchil';
	var $column_order5 = array('birthdate','childname','emplidno',null); //set column field database for datatable orderable
	var $column_search5 = array('birthdate','childname','emplidno'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order5 = array('emplidno' => 'desc'); // default order

	var $table6 = 'emplschl';
	var $column_order6 = array('year','schlcode',null); //set column field database for datatable orderable
	var $column_search6 = array('year','schlcode'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order6 = array('emplidno' => 'desc'); // default order

	var $table7 = 'emplwoex';
	var $column_order7 = array('dstart','dend',null); //set column field database for datatable orderable
	var $column_search7 = array('dstart','dend'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order7 = array('emplidno' => 'desc'); // default order

	var $table8 = 'emplsemi';
	var $column_order8 = array('dstart','dend',null); //set column field database for datatable orderable
	var $column_search8 = array('dstart','dend'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order8 = array('emplidno' => 'desc'); // default order

	var $table3 = 'emplfami';
	var $table4 = 'emplemci';

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _employee_get_datatables_query()
	{

		$this->db->from('employee');

		$i = 0;

		foreach ($this->column_search as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function employee_get_datatables()
	{
		$this->_employee_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_count_filtered()
	{
		$this->_employee_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	public function employee_get_by_id($emplidno)
	{
		$this->db->select('*,employee.emplidno as "emplidno"');
		$this->db->from('employee');
		$this->db->join('emplfami', 'employee.emplidno = emplfami.emplcode');
		$this->db->join('emplemci', 'employee.emplidno = emplemci.emplcode');
		$this->db->join('emplwork', 'employee.emplidno = emplwork.emplcode');
		$this->db->join('emplpogr', 'employee.emplidno = emplpogr.emplcode');
		$this->db->where('employee.emplidno',$emplidno);
		$query = $this->db->get();
		return $query->row();
	}
	public function employee_get_by_id1($emplidno)
	{
		$this->db->from($this->table3);
		$this->db->where('try',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_save($data)
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}
	public function employee_fam_save($data1)
	{
		$this->db->insert($this->table3, $data1);
		return $this->db->insert_id();
	}
	public function employee_eci_save($data2)
	{
		$this->db->insert($this->table4, $data2);
		return $this->db->insert_id();
	}
	public function employee_work_save($data3)
	{
		$this->db->insert('emplwork', $data3);
		return $this->db->insert_id();
	}
	public function employee_pgs_save($data4)
	{
		$this->db->insert('emplpogr', $data4);
		return $this->db->insert_id();
	}
	public function employee_update($where, $data)
	{
		$this->db->update($this->table, $data, $where);
		return $this->db->affected_rows();
	}
	public function employee_fami_update($where, $data1)
	{
		$this->db->update('emplfami', $data1, $where);
		return $this->db->affected_rows();
	}
	public function employee_eci_update($where, $data2)
	{
		$this->db->update('emplemci', $data2, $where);
		return $this->db->affected_rows();
	}
	public function employee_work_update($where, $data3)
	{
		$this->db->update('emplwork', $data3, $where);
		return $this->db->affected_rows();
	}
	public function employee_pgs_update($where, $data4)
	{
		$this->db->update('emplpogr', $data4, $where);
		return $this->db->affected_rows();
	}
	public function eci($where, $data2)
	{
		$this->db->update('emplemci', $data2, $where);
		return $this->db->affected_rows();
	}
	public function employee_update1($where, $data1)
	{
		$this->db->update($this->table3, $data1, $where);
		return $this->db->affected_rows();
	}

	public function employee_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table);

		$this->db->where('emplcode', $emplidno);
		$this->db->delete($this->table3);

		$this->db->where('emplcode', $emplidno);
		$this->db->delete($this->table4);

		$this->db->where('emplcode', $emplidno);
		$this->db->delete('emplwork');

		$this->db->where('emplcode', $emplidno);
		$this->db->delete('emplchil');

		$this->db->where('emplcode', $emplidno);
		$this->db->delete('emplwoex');

		$this->db->where('emplcode', $emplidno);
		$this->db->delete('emplsemi');
	}
	//employee educational background model

		private function _employee_educ_get_datatables_query()
	{


$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table1);

		$i = 0;

		foreach ($this->column_search1 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search1) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order1[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order1))
		{
			$order1 = $this->order1;
			$this->db->order_by(key($order1), $order1[key($order1)]);
		}
	}

	function employee_educ_get_datatables()
	{
		$this->_employee_educ_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_educ_count_filtered()
	{
		$this->_employee_educ_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_educ_count_all()
	{
		$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table1);
		return $this->db->count_all_results();
	}

	public function employee_educ_get_by_id($emplidno)
	{
		$this->db->from($this->table1);
		$this->db->where('emplidno',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_educ_save($data)
	{
		$this->db->insert($this->table1, $data);
		return $this->db->insert_id();
	}

	public function employee_educ_update($where, $data)
	{
		$this->db->update($this->table1, $data, $where);
		return $this->db->affected_rows();
	}

	public function employee_educ_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table1);
	}
//validation for unique id Number
	public function validateid($empnum){
		$this->db->select('emplidno');
    $this->db->where('emplidno', $empnum);
    $this->db->from('employee', 1);
    $query = $this->db->get();

    if( $query->num_rows() > 0 ){     return 0;    }
    else{    return 1;   }
	}
//validate for username
	public function validateusername($un){
		$this->db->select('username');
    $this->db->where('username', $un);
    $this->db->from('employee', 1);
    $query = $this->db->get();

    if( $query->num_rows() > 0 ){     return 0;    }
    else{    return 1;   }
	}
	//end employee educational background model

	//employee child model

		private function _employee_child_get_datatables_query()
	{


		$this->db->where('emplcode',$this->session->userdata('TRY'));
		$this->db->from($this->table5);

		$i = 0;

		foreach ($this->column_search5 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search5) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order5[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order5))
		{
			$order5 = $this->order5;
			$this->db->order_by(key($order5), $order5[key($order5)]);
		}
	}

	function employee_child_get_datatables()
	{
		$this->_employee_child_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_child_count_filtered()
	{
		$this->_employee_child_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_child_count_all()
	{
		$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table5);
		return $this->db->count_all_results();
	}

	public function employee_child_get_by_id($emplidno)
	{
		$this->db->from($this->table5);
		$this->db->where('emplidno',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_child_save($data)
	{
		$this->db->insert($this->table5, $data);
		return $this->db->insert_id();
	}

	public function employee_child_update($where, $data)
	{
		$this->db->update($this->table5, $data, $where);
		return $this->db->affected_rows();
	}

	public function employee_child_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table5);
	}
	//end employee child model

	//employee scholar model

		private function _employee_scholar_get_datatables_query()
	{
		$this->db->where('emplcode',$this->session->userdata('TRY'));
		$this->db->from($this->table6);

		$i = 0;

		foreach ($this->column_search6 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search6) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order6[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order6))
		{
			$order6 = $this->order6;
			$this->db->order_by(key($order6), $order6[key($order6)]);
		}
	}

	function employee_scholar_get_datatables()
	{
		$this->_employee_scholar_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_scholar_count_filtered()
	{
		$this->_employee_scholar_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_scholar_count_all()
	{
		$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table6);
		return $this->db->count_all_results();
	}

	public function employee_scholar_get_by_id($emplidno)
	{
		$this->db->from($this->table6);
		$this->db->where('emplidno',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_scholar_save($data)
	{
		$this->db->insert($this->table6, $data);
		return $this->db->insert_id();
	}

	public function employee_scholar_update($where, $data)
	{
		$this->db->update($this->table6, $data, $where);
		return $this->db->affected_rows();
	}

	public function employee_scholar_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table6);
	}
	//end employee scholar model


	//employee work experience model

		private function _employee_woex_get_datatables_query()
	{


		$this->db->where('emplcode',$this->session->userdata('TRY'));
		$this->db->from($this->table7);

		$i = 0;

		foreach ($this->column_search7 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search7) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order7[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order7))
		{
			$order7 = $this->order7;
			$this->db->order_by(key($order7), $order7[key($order7)]);
		}
	}

	function employee_woex_get_datatables()
	{
		$this->_employee_woex_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_woex_count_filtered()
	{
		$this->_employee_woex_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_woex_count_all()
	{
		$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table7);
		return $this->db->count_all_results();
	}

	public function employee_woex_get_by_id($emplidno)
	{
		$this->db->from($this->table7);
		$this->db->where('emplidno',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_woex_save($data)
	{
		$this->db->insert($this->table7, $data);
		return $this->db->insert_id();
	}

	public function employee_woex_update($where, $data)
	{
		$this->db->update($this->table7, $data, $where);
		return $this->db->affected_rows();
	}

	public function employee_woex_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table7);
	}
	//end employee work experience model

	//employee seminar and training model

		private function _employee_semi_get_datatables_query()
	{


		$this->db->where('emplcode',$this->session->userdata('TRY'));
		$this->db->from($this->table8);

		$i = 0;

		foreach ($this->column_search8 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search8) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order8[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order8))
		{
			$order8 = $this->order8;
			$this->db->order_by(key($order8), $order8[key($order8)]);
		}
	}

	function employee_semi_get_datatables()
	{
		$this->_employee_semi_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_semi_count_filtered()
	{
		$this->_employee_semi_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_semi_count_all()
	{
		$this->db->where('emplcode', $this->session->userdata('TRY'));
		$this->db->from($this->table8);
		return $this->db->count_all_results();
	}

	public function employee_semi_get_by_id($emplidno)
	{
		$this->db->from($this->table8);
		$this->db->where('emplidno',$emplidno);
		$query = $this->db->get();

		return $query->row();
	}

	public function employee_semi_save($data)
	{
		$this->db->insert($this->table8, $data);
		return $this->db->insert_id();
	}

	public function employee_semi_update($where, $data)
	{
		$this->db->update($this->table8, $data, $where);
		return $this->db->affected_rows();
	}

	public function employee_semi_delete_by_id($emplidno)
	{
		$this->db->where('emplidno', $emplidno);
		$this->db->delete($this->table8);
	}
	//end employee seminar and training model

}
