<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ca_model extends CI_Model {

	var $table = 'emplmenu';
	var $column_order = array('menu'); //set column field database for datatable orderable
	var $column_search = array('menu'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order = array('segment' => 'asc'); // default order

	var $table1 = 'userlvl';
	var $column_order1 = array('userlvl','description'); //set column field database for datatable orderable
	var $column_search1 = array('userlvl'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order1 = array('lvlidno' => 'desc'); // default order


	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _userlvl_get_datatables_query()
	{

		$this->db->from('userlvl');

		$i = 0;

		foreach ($this->column_search1 as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search1) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order1[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order1))
		{
			$order1 = $this->order1;
			$this->db->order_by(key($order1), $order1[key($order1)]);
		}
	}

	function userlvl_get_datatables()
	{
		$this->_userlvl_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function userlvl_count_filtered()
	{
		$this->_userlvl_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function userlvl_count_all()
	{
		$this->db->from($this->table1);
		return $this->db->count_all_results();
	}

	public function userlvl_save($data)
	{
		$this->db->insert($this->table1, $data);
		return $this->db->insert_id();
	}

	public function userlvl_update1($where, $data)
	{
		$this->db->update('userlvl', $data, $where);
		return $this->db->affected_rows();
	}

	public function userlvl_get_by_id($lvlidno)
	{
		$this->db->select('*');
		$this->db->from('userlvl');
		$this->db->where('lvlidno',$lvlidno);
		$query = $this->db->get();
		return $query->row();
	}


	public function userlvl_delete_by_id($lvlidno)
	{
		$this->db->where('lvlidno', $lvlidno);
		$this->db->delete('userlvl');

		$this->db->where('lvlidno', $lvlidno);
		$this->db->delete('emplmenu');

	}
	private function _employee_ap_get_datatables_query()
	{
if(isset($_SESSION['lvlidno']))
{
$this->db->where('lvlidno', $_SESSION['lvlidno']);
}
		$this->db->from('emplmenu');

		$i = 0;

		foreach ($this->column_search as $item) // loop column
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{

				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}

		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		}
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function employee_ap_get_datatables()
	{
		$this->_employee_ap_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function employee_ap_count_filtered()
	{
		$this->_employee_ap_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function employee_ap_count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	public function employee_ap_get_by_id($emenuidno)
	{$this->db->select('*');
		$this->db->from('emplmenu');
		$this->db->where('emenuidno',$emenuidno);
		$query = $this->db->get();
		return $query->row();
	}

	public function employee_ap_delete_by_id($emenuidno)
	{
		$this->db->where('emenuidno', $emenuidno);
		$this->db->update($this->table,array('showmenu' => 'No'));

	}

	public function employee_ap_delete_by_id1($emenuidno)
	{
		$this->db->where('emenuidno', $emenuidno);
		$this->db->update($this->table,array('showmenu' => 'Yes'));

	}

	public function user_save($data)
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}


	public function usermenu_save($data1)
	{
		$this->db->insert('emplmenu', $data1);
	//	return $this->db->insert_id();
	}

	public function mainmenu_list()
	{
	$this->db->where('menutype', 'Main');
	return $this->db->get('mainmenu')->result();
	}

	function usermenu_get_datatables()
	{
		$this->load->database();
		$this->db->where('menutype', 'Main');
		$query=$this->db->get('mainmenu');
		return $query->result();
	}

	function userlvl_get_datatables1()
	{
		$this->load->database();
		$query=$this->db->get('userlvl');
		return $query->result();
	}

	function count_rec_user(){
		$this->load->database();
		//$this->db->where('menutype', 'Main');
		$query=$this->db->get('userlvl');
		return $query->num_rows();
	}

	function usermenus_get_datatables($menuof)
	{
		$this->load->database();
		//$this->db->where('menutype', 'Sub-Menu');
		$this->db->where('menuof', $menuof);
		$query=$this->db->get('mainmenu');
		return $query->result();
	}

	function counts_rec_user($menuof){
		$this->load->database();
		//$this->db->where('menutype', 'Sub-Menu');
		$this->db->where('menuof', $menuof);
		$query=$this->db->get('userlvl');
		return $query->num_rows();
	}

	function usermenum_get_datatables($menuof)
	{
		$this->load->database();
		$this->db->where('menutype', 'Main');
		$this->db->where('menuof', $menuof);
		$query=$this->db->get('mainmenu');
		return $query->result();
	}

	function countm_rec_user($menuof){
		$this->load->database();
		$this->db->where('menutype', 'Main');
		$this->db->where('menuof', $menuof);
		$query=$this->db->get('mainmenu');
		return $query->num_rows();
	}
}
